-- 1. Create any custom particle properties
pAge              = Allocate(1);  
pSpin             = Allocate(1); -- Allocate a TReal spin member
pSpinSpeed   = Allocate(1); -- Allocate a TReal spin member
pVelocity       = Allocate(2) ;

-- 2. Set the particle texture and blend mode
  SetTexture("confettijaune01");
  SetBlendMode(kBlendNormal);

-- 3. Set the number of particle in the system
  SetNumParticles(15);

-- 4. INIT
pPosition:Init(fRange(Vec2(0,0), Vec2(0,0)));

pScale:Init(fRange(.3,.6));

pAge:Init(fRange(0,0));

pVelocity:Init( fRange( Vec2(-200,-280), Vec2(200,-350)));

pSpin:Init( fRange( 0, 2*3.1415927 ) );

pSpinSpeed:Init( 2,.5);


pColor:Anim(fFade( pAge, Color(1, 1, 1, 1),50000, 
    Color(1, 1, 1, .2)));

-- 5. ANIMATION
StopSpouting = NewTimeout(5);
TestDone   = NewTimeout(10);

pVelocity:Anim( pVelocity + fTimeScale(Vec2(0, 300)) );

pPosition:Anim( pPosition + fTimeScale(pVelocity) );

pAge:Anim(pAge + fAge());

-- Spin by pSpinSpeed scaled by time
pSpin:Anim( pSpin + fTimeScale( pSpinSpeed ) );

pUp:Anim( f2dRotation( pSpin ) );


Anim(fExpire(fGreater(pAge,3000)));

-- 6. Defines an Upate function that create particle
function Update(ms)
  if TestDone(ms)  then
    Done();
    return;
  end

  if ( StopSpouting (ms)) then
    return ;
  end
 CreateParticles(.5);

end


